/********************************************************************************
*                                                                               *
*                     S E T I F T P 4 w    C l a s s                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: SETIFTP4w.cpp,v 1.00 2002/11/20 Exp $                                    *
********************************************************************************/
/*
Windows-specific implementation of the SETI FTP class
*/

#include "fx.h"

#include "SETIFTP.h"
#include "SETIFTP4w.h"
#include "ftp4w.h"

//---------------------------------------------------------------------------

SETIFTP * InstantiateFTP()	// This is defined in each OS-specific .cpp
{
	return new SETIFTP4w;
}

//---------------------------------------------------------------------------
// Mighty: 13/nov/02 I have no idea what this does.  Just copied it from cw.c
// It looks like a hard-coded ID for a thread?
/* identifiant du Thread */
DWORD far Ftp4wIdentThread()
{
  return 45ul;
} // Ftp4wIdentThread

//---------------------------------------------------------------------------
SETIFTP4w::SETIFTP4w()
{
// do nothing
}

//---------------------------------------------------------------------------
SETIFTP4w::~SETIFTP4w()
{
// do nothing
}

//---------------------------------------------------------------------------
FXint SETIFTP4w::Init(FXbool i_fPassive)
{
    FXint Rc = FtpMtInit(NULL /*hWnd*/, Ftp4wIdentThread);
    if (SETIFTPERR_OK == Rc)
        {
        FtpSetDefaultTimeOut (30);       /* new Timeout : 30 seconds */
        FtpSetNewDelay(10);
		FtpSetVerboseMode (TRUE, 0, 0);   //m_hWnd, WM_VERBOSESTRING);
		FtpSetSynchronousMode ();	// FtpSetAsynchronousMode
	    FtpSetPassiveMode (i_fPassive);
        }
	return Rc;
}

//---------------------------------------------------------------------------
FXint SETIFTP4w::Login(FXString i_strServer,
						FXString i_strUsername,
						FXString i_strPassword,
						FXString i_strFirewallServer,
						FXString i_strFirewallUsername,
						FXString i_strFirewallPassword,
						FXint i_nFirewallIndex)
{
	FXint l_nReturn = 0;
	FXint l_nFirewallType = 0;
	switch ( i_nFirewallIndex )
		{
		case 0 :
			l_nFirewallType = 0;
			break;
		case 1 :
			l_nFirewallType = FTP4W_FWSITE;
			break;
		case 2 :
			l_nFirewallType = FTP4W_FWPROXY;
			break;
		case 3 :
			l_nFirewallType = FTP4W_FWUSERWITHLOGON;
			break;
		case 4 :
			l_nFirewallType = FTP4W_FWUSERNOLOGON;
			break;
		default:
			l_nReturn = SETIFTPERR_INVALIDFIREWALL;
			break;
		}

	if ( !l_nReturn )
		{
		if ( i_nFirewallIndex )
			{
		    l_nReturn = FtpFirewallLogin ( i_strServer.text(), 	// HOST_NAME (),
		                            i_strUsername.text(),		// USER_NAME (),
		                            i_strPassword.text(),		// PASSWD_NAME (),
		                            i_strFirewallServer.text(), // REM_HOSTNAME(),
		                            i_strFirewallUsername.text(), // REM_USERNAME(),
		                            i_strFirewallPassword.text(), // REM_PASSWD (),
		                            l_nFirewallType, 			// FIREWALL_TYPE,
		                            NULL, //(HWND)(FXApp::instance()->getMainWindow()->id()), // hWnd,
									0); // FTP_LOGGED); // FTP_LOGGED);
			}
		else
			{
		    l_nReturn = FtpLogin ( i_strServer.text(),
		                    i_strUsername.text(),
		                    i_strPassword.text(),
		                    NULL, //hWnd,
							FALSE); // FTP_LOGGED);
			}
		}

	return l_nReturn;
}

//---------------------------------------------------------------------------
FXint SETIFTP4w::SendFile(FXString i_strLocalFilename,
						   FXString i_strRemoteFilename)
{
	FXint l_nReturn = FtpSendFile (  i_strLocalFilename.text(),	// LOCALFILE_NAME (),
		                i_strRemoteFilename.text(),	// REMOTEFILE_NAME (),
		                TYPE_A, 				// IsOptOn(CW_BINARY) ? TYPE_I : TYPE_A,
		                FALSE, 					// IsOptOn(CW_GAUGE),
		                NULL, 					// hWnd,
		                0);						// (LPARAM) FTP_FILETRANSFERED);
	return l_nReturn;
}

//---------------------------------------------------------------------------
FXint SETIFTP4w::Disconnect()
{
	FXint l_nReturn = FtpCloseConnection ();
	if ( SETIFTPERR_OK == l_nReturn )
		{
	    FtpLocalClose ();
	    l_nReturn = FtpRelease();
		}
	return l_nReturn;
}

//---------------------------------------------------------------------------
FXint SETIFTP4w::Shutdown()
{
// Do nothing
return 0;
}

//---------------------------------------------------------------------------
