/********************************************************************************
*                                                                               *
*                       S E T I F T P    C l a s s                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: SETIFTP.h,v 1.00 2002/11/14 Exp $                                        *
********************************************************************************/
#ifndef SETIFTP_H
#define SETIFTP_H

class SETIFTP;

SETIFTP * InstantiateFTP();	// This is defined in each OS-specific .cpp

class SETIFTP
{
public:
	SETIFTP() { }
	virtual ~SETIFTP() { }

	virtual FXint Init(FXbool i_fPassive) = 0;
	virtual FXint Login(FXString i_strServer,
						FXString i_strUsername,
						FXString i_strPassword,
						FXString i_strFirewallServer,
						FXString i_strFirewallUsername,
						FXString i_strFirewallPassword,
						FXint i_nFirewallType) = 0;
	virtual FXint SendFile(FXString i_strLocalFilename,
						   FXString i_strRemoteFilename) = 0;
	virtual FXint Disconnect() = 0;
	virtual FXint Shutdown() = 0;

	FXString ErrorToString(FXint i_nError);

protected:
};

// 02/nov/20 For now, these error codes are lifted from ftp4w.  If I ever
// implement a different ftp library I'll need some sort of translation from
// those error codes to these

/* ----------------------------------------------------------- */
/*              Return codes of FTP functions                  */
/* ----------------------------------------------------------- */
/* success */
#define  SETIFTPERR_OK                    0 /* succesful function                */
/* OK but waits for further parameters */
#define  SETIFTPERR_ENTERPASSWORD         1 /* userid need a password            */
#define  SETIFTPERR_ENTERACCOUNT          2 /* user/pass OK but account required */
#define  SETIFTPERR_ACCOUNTNEEDED         2 /* user/pass OK but account required */
#define  SETIFTPERR_RESTARTOK             3 /* Restart command successful        */
#define  SETIFTPERR_ENDOFDATA             4  /* server has closed the data-conn   */
#define  SETIFTPERR_CANCELBYUSER         -1 /* Transfer aborted by user FtpAbort */
/* user's or programmer's Errors  */
#define  SETIFTPERR_INVALIDPARAMETER   1000 /* Error in parameters               */
#define  SETIFTPERR_SESSIONUSED        1001 /* User has already a FTP session    */
#define  SETIFTPERR_NOTINITIALIZED     1002 /* FtpInit has not been call         */
#define  SETIFTPERR_NOTCONNECTED       1003 /* User is not connected to a server */
#define  SETIFTPERR_CANTOPENFILE       1004 /* can not open specified file       */
#define  SETIFTPERR_CANTOPENLOCALFILE  SETIFTPERR_CANTOPENFILE
#define  SETIFTPERR_CANTWRITE          1005 /* can't write into file (disk full?)*/
#define  SETIFTPERR_NOACTIVESESSION    1006 /* FtpRelease without FtpInit        */
#define  SETIFTPERR_STILLCONNECTED     1007 /* FtpRelease without any Close      */
#define  SETIFTPERR_SERVERCANTEXECUTE  1008 /* file action not taken             */
#define  SETIFTPERR_LOGINREFUSED       1009 /* Server rejects usrid/passwd       */
#define  SETIFTPERR_NOREMOTEFILE       1010 /* server can not open file          */
#define  SETIFTPERR_TRANSFERREFUSED    1011 /* Host refused the transfer         */
#define  SETIFTPERR_WINSOCKNOTUSABLE   1012 /* A winsock.DLL ver 1.1 is required */
#define  SETIFTPERR_CANTCLOSE          1013 /* Close failed (cmd is in progress) */
#define  SETIFTPERR_FILELOCKED         1014 /* temporary error during FtpDelete  */
#define  SETIFTPERR_FWLOGINREFUSED     1015 /* Firewallrejects usrid/passwd      */
#define  SETIFTPERR_ASYNCMODE          1016 /* FtpMGet only in synchronous mode  */
#define  SETIFTPERR_INVALIDFIREWALL    1017 /* Unknown firewall type			 */
/* TCP errors */
#define  SETIFTPERR_UNKNOWNHOST        2001 /* can not resolve host adress       */
#define  SETIFTPERR_NOREPLY            2002 /* host does not send an answer      */
#define  SETIFTPERR_CANTCONNECT        2003 /* Error during connection           */
#define  SETIFTPERR_CONNECTREJECTED    2004 /* host has no FTP server            */
#define  SETIFTPERR_SENDREFUSED        2005 /* can't send data (network down)    */
#define  SETIFTPERR_DATACONNECTION     2006 /* connection on data-port failed    */
#define  SETIFTPERR_TIMEOUT            2007 /* timeout occured                   */
#define  SETIFTPERR_FWCANTCONNECT      2008 /* Error during connection with FW   */
#define  SETIFTPERR_FWCONNECTREJECTED  2009 /* Firewall has no FTP server        */
/* FTP server errors */
#define  SETIFTPERR_UNEXPECTEDANSWER   3001  /* answer was not expected          */
#define  SETIFTPERR_CANNOTCHANGETYPE   3002  /* host rejects the TYPE command    */
#define  SETIFTPERR_CMDNOTIMPLEMENTED  3003  /* host recognize but can't exec cmd*/
#define  SETIFTPERR_PWDBADFMT          3004  /* PWD cmd OK, but answer has no "  */
#define  SETIFTPERR_PASVCMDNOTIMPL     3005  /* Server don't support passive mode*/
/* Resource errors */
#define  SETIFTPERR_CANTCREATEWINDOW   5002  /* Insufficent free resources       */
#define  SETIFTPERR_INSMEMORY          5003  /* Insuffisent Heap memory          */
#define  SETIFTPERR_CANTCREATESOCKET   5004  /* no more socket                   */
#define  SETIFTPERR_CANTBINDSOCKET     5005  /* bind is not succesful            */
#define  SETIFTPERR_SYSTUNKNOWN        5006  /* host system not in the list      */


#endif // SETIFTP_H
