/********************************************************************************
*                                                                               *
*                       S E T I F T P    C l a s s                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: SETIFTP.cpp,v 1.00 2002/11/14 Exp $                                      *
********************************************************************************/

#include "fx.h"
#include "SETIFTP.h"

#define SizeOfTab(t)   ( sizeof (t) / sizeof (t[0]) )

struct S_ErrorStrings
{
   int   ErrorCode;
   char * ErrorString;
}; /* struct S_Ftp4wErr */

struct S_ErrorStrings sErrorStrings [] =
{
   { SETIFTPERR_OK,                  "Successful function"                    },
   { SETIFTPERR_ENTERPASSWORD,       "Enter a password"                       },
   { SETIFTPERR_ENTERACCOUNT,        "Enter account"                          },
   { SETIFTPERR_ACCOUNTNEEDED,       "Enter account"                          },
   { SETIFTPERR_RESTARTOK,           "Restart command successful"             },
   { SETIFTPERR_CANCELBYUSER,        "Transfer aborted by FtpAbort"           },
   { SETIFTPERR_ENDOFDATA,           "Server has closed the data connection"  },
   { SETIFTPERR_INVALIDPARAMETER,    "Error in parameters"                    },
   { SETIFTPERR_SESSIONUSED,         "User has already a FTP session"         },
   { SETIFTPERR_NOTINITIALIZED,      "FtpInit has not been called"            },
   { SETIFTPERR_NOTCONNECTED,        "User is not connected to a server"      },
   { SETIFTPERR_CANTOPENFILE,        "Can not open specified file"            },
   { SETIFTPERR_CANTOPENLOCALFILE,   "Can not open specified file"            },
   { SETIFTPERR_CANTWRITE,           "Can not write into file (disk full?)"   },
   { SETIFTPERR_NOACTIVESESSION,     "FtpRelease without FtpInit"             },
   { SETIFTPERR_STILLCONNECTED,      "FtpRelease without any Close"           },
   { SETIFTPERR_SERVERCANTEXECUTE,   "File action not taken"                  },
   { SETIFTPERR_LOGINREFUSED,        "Server rejects userid/passwd"           },
   { SETIFTPERR_NOREMOTEFILE,        "Server can not open remote file"        },
   { SETIFTPERR_TRANSFERREFUSED,     "Host refused the transfer"              },
   { SETIFTPERR_WINSOCKNOTUSABLE,    "A winsock.DLL ver 1.1 is required"      },
   { SETIFTPERR_CANTCLOSE,           "Close failed (cmd is in progress)"      },
   { SETIFTPERR_FILELOCKED,          "Temporary error during FtpDelete"       },
   { SETIFTPERR_FWLOGINREFUSED,      "Firewall rejects userid/passwd"         },
   { SETIFTPERR_ASYNCMODE,           "Function available only in synchronous mode" },
   { SETIFTPERR_INVALIDFIREWALL,     "Unknown firewall type"				  },
   { SETIFTPERR_UNKNOWNHOST,         "Can not resolve host adress"            },
   { SETIFTPERR_NOREPLY,             "Host does not send an answer"           },
   { SETIFTPERR_CANTCONNECT,         "Error during connection"                },
   { SETIFTPERR_CONNECTREJECTED,     "Host has no FTP server"                 },
   { SETIFTPERR_SENDREFUSED,         "Can not send data (network down)"       },
   { SETIFTPERR_DATACONNECTION,      "Connection on data-port failed"         },
   { SETIFTPERR_TIMEOUT,             "Timeout occured"                        },
   { SETIFTPERR_FWCANTCONNECT,       "Error during connection with Firewall " },
   { SETIFTPERR_FWCONNECTREJECTED,   "Firewall has no FTP server"             },
   { SETIFTPERR_UNEXPECTEDANSWER,    "Answer was not expected"                },
   { SETIFTPERR_CANNOTCHANGETYPE,    "Host rejects the TYPE command"          },
   { SETIFTPERR_CMDNOTIMPLEMENTED,   "Command not implemented"                },
   { SETIFTPERR_PWDBADFMT,           "PWD cmd OK, but answer has no directory"},
   { SETIFTPERR_PASVCMDNOTIMPL,      "Server don't support passive mode"      },
   { SETIFTPERR_CANTCREATEWINDOW,    "Insuffisent free resources"             },
   { SETIFTPERR_INSMEMORY,           "Insuffisent Heap memory"                },
   { SETIFTPERR_CANTCREATESOCKET,    "No socket available"                    },
   { SETIFTPERR_CANTBINDSOCKET,      "Bind is not succesful"                  },
   { SETIFTPERR_SYSTUNKNOWN,         "Host system not in the list"            },
}; /* sErrorStrings */

//---------------------------------------------------------------------------
FXString SETIFTP::ErrorToString(FXint i_nError)
{
int Idx;
   for ( Idx=0 ;
         Idx<SizeOfTab(sErrorStrings) && sErrorStrings[Idx].ErrorCode!=i_nError;
         Idx++ );
return Idx>= SizeOfTab(sErrorStrings) ?   (char *) "Unknown FTP return code" :
                                      sErrorStrings[Idx].ErrorString;
}
