/********************************************************************************
*                                                                               *
*                     MightySETIInfoWindow Class                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: MightySETIInfo.h,v 1.00 2003/01/15 Exp $                                  *
********************************************************************************/

class DebugFlags;

//---------------------------------------------------------------------------
// Main Window
class MightySETIInfoWindow : public FXMainWindow {
  FXDECLARE(MightySETIInfoWindow)
public:
	long onCmdAbout(FXObject*,FXSelector,void*);
	/// Write the files
	long onCmdDoIt(FXObject*,FXSelector,void*);
	/// Enable Once then exit
	long onCmdOnceThenExit(FXObject*,FXSelector,void*);
	/// Update the control
	long onUpdOnceThenExit(FXObject*,FXSelector,void*);
	/// Choose the input file
	long onCmdBrowseUserInfo(FXObject*,FXSelector,void*);
	/// Choose the HTML input file
	long onCmdBrowseHTMLIn(FXObject*,FXSelector,void*);
	/// Choose the output file
	long onCmdBrowseHTML(FXObject*,FXSelector,void*);
	/// Choose the sig input file
	long onCmdBrowseSigIn(FXObject*,FXSelector,void*);
	/// Choose the output file
	long onCmdBrowseSig(FXObject*,FXSelector,void*);
	/// Pop up main config dialog
	long onCmdShowMainConfig(FXObject*,FXSelector,void*);
	/// Show FTP dialog
	long onCmdShowFTP(FXObject*,FXSelector,void*);
	/// Show debug dialog
	long onCmdShowDebug(FXObject*,FXSelector,void*);
	/// Read the setup files
	long onIdleTaskStartup(FXObject*,FXSelector,void*);
	/// Perform the FTP after the UI has time to update
	long onFTPChore(FXObject*,FXSelector,void*);
	/// Drop FTP Transfered box after a delay
	long onTimerContinue(FXObject*,FXSelector,void*);
	/// Shut it down after a delay
	long onTimerShutdown(FXObject*,FXSelector,void*);
	/// Eventually we'll show time to next writes
	long onTimerHeartbeat(FXObject*,FXSelector,void*);

public:
  enum{
    ID_ABOUT=FXMainWindow::ID_LAST,
	ID_IDLETASKSTARTUP,
	ID_FTPCHORE,
	ID_TIMERTOCONTINUE,
	ID_TIMERTOSHUTDOWN,
	ID_TIMERHEARTBEAT,
	ID_BTNDOIT,
	ID_BTNCONFIGURE,
	ID_CHKONCETHENEXIT,
	ID_SETUSERINFO,
	ID_SETSIGINPUT,
	ID_SETSIGOUTPUT,
	ID_SETHTMLINPUT,
	ID_SETHTMLOUTPUT,
	ID_SHOWMAINCONFIG,
	ID_BTNOUTPUTFTP,
	ID_SHOWFTP,
	ID_SHOWDEBUG,
    ID_LAST
    };
public:
  MightySETIInfoWindow(FXApp* a);
  virtual void create();
  virtual ~MightySETIInfoWindow();

protected:
	/// Protect from default constructor
	MightySETIInfoWindow(){}
	/// Find the current input file (Takes Setihide into account)
	FXString GetInputFilename();
	/// Read the SETI files
	FXbool ReadSETIFiles(FXString i_strFilename);
	/// Replace a label with a string
	void ReplaceString(FXString *i_strInput, const FXString ik_strField, const FXString ik_strReplacement);
	/// Replace an label with an int
	void ReplaceInt(FXString *i_strInput, const FXString ik_strField, const FXuint ik_uInt, const FXString ik_strLabel = "");
	/// Replace an label with an float
	void ReplaceFloat(FXString *i_strInput, const FXString ik_strField, const FXdouble ik_rNum, const FXString ik_strLabel = "");
	/// Load a template file and do the replacements
	FXbool DoReplacements(const FXString ik_strFilename, FXString * i_strTemplate);
	/// Build email sig
	FXbool CreateSigString();
	/// Build HTML content
	FXbool CreateHTMLString();
	/// Write the email sig files
	FXbool WriteSigFile();
	/// Write the email sig files
	FXbool WriteHTMLFile();
	/// Write a text string to a file
	FXbool WriteFile(const FXString i_strTitle, const SETIText *i_txtContent, const FXString i_strFilename);
	/// First time in
	void DoItFirstTime();
	/// Actually do the work
	void DoIt();
	/// Handle a heartbeat
	void Heartbeat();
	/// Build the time left string
	FXString MakeTimeLeftString(FXint i_nSecsLeft);
	/// Display time left until next Sig write
	void DisplaySigTimeLeft();
	/// Return seconds until next action.  <=0 means past time
	FXint CalcSigTimeLeft();
	/// Return TRUE if time to do something
	FXbool CheckSigCountdown();
	/// Display time left until next HTML write
	void DisplayHTMLTimeLeft();
	/// Return seconds until next action.  <=0 means past time
	FXint CalcHTMLTimeLeft();
	/// Return TRUE if time to do something
	FXbool CheckHTMLCountdown();
	/// Start the heartbeat timer
	void Defibrillate();
	/// Stop the heartbeat timer
	void KillHeartbeat();
	/// Start the shutdown timer
	void SetShutdownTimer();
	/// Set up the FTP chore
	void SetFTPChore();
	/// Actually do the FTP
	void DoFTPChore();
	/// Generate a default INI
	void WriteDefaultINI();
	/// Generate default FTP INI settings
	void WriteDefaultFTP();
	/// Convert seconds into mins, hours, days
	struct tm ConvertSecsTotmstruct(FXint i_nInterval);
	/// Write the current INI info
	FXbool WriteINI();
	/// Write formatted current date/time to INI file
	void WriteDateTime(FXString i_strSection, FXString i_strKey);
	/// Consolidate common functions when writing ini.  Check to see if should do it, and if so, do it
	void WriteINIAndDoIt(FXbool i_fExtraTest=TRUE);
	/// Add an entry to the log window
	void Log(FXString i_str);
	/// Clear the Sig window
	void ClearSig();
	/// Clear the HTML window
	void ClearHTML();
	/// Clear all the boxes
	void ClearBoxes();
	/// Load struct with info from settings file
	void GetFTPSettings(FTPSettings * i_pFTPSettings);
	/// Save struct with info from settings file
	void SaveFTPSettings(FTPSettings * i_pFTPSettings);
	/// FTP the file up to the server
	FXbool FTPFile(const FTPSettings *i_pFTPSettings, FXString i_strFilename);
	/// Display the output to the user
	void DisplaySig();
	void DisplayHTML();

	// Debug output routines
	void DisplayPrefs();
	void appendPrefs(const FXString i_str);
	void appendUserInfo(const FXString i_str);
	void appendWorkUnit(const FXString i_str);
	void appendLog(const FXString i_str);

	// If the number is not one, then add an S to the end of the string
	FXString Pluralize(const FXString i_strWord, const FXuint i_uNumber) const;
	// Return S if number is not 1
	const FXchar * AddS(const FXuint i_uNumber) const;

	// Date functions to read from settings
	struct tm GetLastWrittenSig();
	struct tm GetLastWrittenHTML();
	struct tm ParseATime(FXString i_strTime, const FXchar * i_arrcDefault);

	// Date functions for string substitutions
	FXString GetCurDateString();
	FXString GetCurDateYear();
	FXString GetCurDateYr();
	FXString GetCurDateMonth();
	FXString GetCurDateMonthNum();
	FXString GetCurDateMon();
	FXString GetCurDateDayOfYear();
	FXString GetCurDateDayOfMon();
	FXString GetCurDateDayOfWeek();
	FXString GetCurDateDayOfWk();
	FXString GetCurDateHour12();
	FXString GetCurDateHour24();
	FXString GetCurDateAMPM();
	FXString GetCurDateMinute();
	FXString GetCurDateSecond();

	FXString GetProgramVersion();
	FXString GetRandomQuote();

protected:
	FXMenubar*			menubar;
	FXMenuPane*			filemenu;
	FXMenuPane*			m_menuConfigure;
	FXMenuPane*			m_menuDebug;
	FXMenuPane*			helpmenu;

	FXCheckButton*		m_chkOnceThenExit;
	FXButton*			m_btnConfigure;
	FXButton*			m_btnDoIt;

	SETIText*			m_txtSig;
	SETIText*			m_txtHTML;

	FXTextField*		m_txtfldOutputSig;
	FXTextField*		m_txtfldOutputHTML;
	FXTextField*		m_txtfldOutputFTP;	// non-editable
	FXGroupBox*			m_grpboxSig;
	FXGroupBox*			m_grpboxHTML;
	FXCheckButton*		m_chkEnableSig;
	FXCheckButton*		m_chkEnableHTML;
	FXCheckButton*		m_chkEnableFTP;		// Dupe of field in FTP dialog
	FXButton*			m_btnBrowseOutputSig;
	FXButton*			m_btnBrowseOutputHTML;
	FXButton*			m_btnConfigOutputFTP;

	DebugDialog*		m_pdialogDebug;
	DebugFlags *		m_pDebugFlags;

	FXMessageBox*		m_dlgFTPContinue;
	FTPProgressDialog*	m_dlgFTPProgress;

	SETIInfo			m_info;

	FXSettings			m_MainSettings;
	FTPSettings			m_FTPSettings;

	FXString			m_strSig;
	FXString			m_strHTML;

	FXString			m_strUpdateOnceThenExit;
	FXint				m_uDelayBeforeExit;

	FXTimer *			m_ptimerHeartbeat;
  };

