/********************************************************************************
*                                                                               *
*                        MainConfigDlg Class                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: MainConfigDlg.h,v 1.00 2003/01/15 Exp $                                  *
********************************************************************************/

class MainConfigDialog : public FXDialogBox
{
	FXDECLARE(MainConfigDialog)
public:
	MainConfigDialog(FXWindow* owner, FXSettings * i_pSettings,
			FTPSettings * i_pFTPSettings, DebugDialog * i_pdialogDebug);
	virtual ~MainConfigDialog();

	virtual void show();
	virtual FXuint execute(FXuint placement=PLACEMENT_OWNER);

	/// Enable Once then exit
	long onCmdOnceThenExit(FXObject*,FXSelector,void*);
	/// Update the control
	long onUpdOnceThenExit(FXObject*,FXSelector,void*);
	/// Using SetiHide
	long onCmdSetiHide(FXObject*,FXSelector,void*);
	/// Update the control
	long onUpdSetiHide(FXObject*,FXSelector,void*);
	/// Choose the input file
	long onCmdBrowseUserInfo(FXObject*,FXSelector,void*);
	/// Display the input file
	long onCmdUserInfo(FXObject*,FXSelector,void*);
	/// Display the input file
	long onUpdUserInfo(FXObject*,FXSelector,void*);
	/// Jump to default SETI@Home folder
	long onCmdDefaultLocation(FXObject*,FXSelector,void*);
	/// Choose the sig input file
	long onCmdBrowseSigIn(FXObject*,FXSelector,void*);
	/// Save changes to sig input file
	long onCmdSigIn(FXObject*,FXSelector,void*);
	/// Display the sig input file
	long onUpdSigIn(FXObject*,FXSelector,void*);
	/// Choose the output file
   	long onCmdBrowseSig(FXObject*,FXSelector,void*);
	/// Save changes to the output file
   	long onCmdSig(FXObject*,FXSelector,void*);
	/// Display the output file
   	long onUpdSig(FXObject*,FXSelector,void*);
	/// Enable output to sig file
	long onCmdEnableSig(FXObject*,FXSelector,void*);
	/// Update the control
	long onUpdEnableSig(FXObject*,FXSelector,void*);
	/// Choose the HTML input file
	long onCmdBrowseHTMLIn(FXObject*,FXSelector,void*);
	/// Save changes to the HTML input file
	long onCmdHTMLIn(FXObject*,FXSelector,void*);
	/// Display the HTML input file
	long onUpdHTMLIn(FXObject*,FXSelector,void*);
	/// Choose the output file
	long onCmdBrowseHTML(FXObject*,FXSelector,void*);
	/// Save changes to the output file
	long onCmdHTML(FXObject*,FXSelector,void*);
	/// Display the output file
	long onUpdHTML(FXObject*,FXSelector,void*);
	/// The sig time changed
	long onCmdTimeSig(FXObject*,FXSelector,void*);
	/// Display the sig time
	long onUpdTimeSig(FXObject*,FXSelector,void*);
	/// The HTML time changed
	long onCmdTimeHTML(FXObject*,FXSelector,void*);
	/// Display the HTML time
	long onUpdTimeHTML(FXObject*,FXSelector,void*);
	/// Enable output to HTML file
	long onCmdEnableHTML(FXObject*,FXSelector,void*);
	/// Update the control
	long onUpdEnableHTML(FXObject*,FXSelector,void*);
	/// Update the FTP server
	long onUpdFTP(FXObject*,FXSelector,void*);
	/// Update the control
	long onUpdShowFTP(FXObject*,FXSelector,void*);
	/// Enable FTP
	long onCmdEnableFTP(FXObject*,FXSelector,void*);
	/// Update the Quote input file
	long onUpdQuote(FXObject*,FXSelector,void*);
	/// Browse the quote file
	long onCmdBrowseQuote(FXObject*,FXSelector,void*);
	/// The Quote delimiter changed
	long onCmdDelimiter(FXObject*,FXSelector,void*);
	/// Display the Quote delimiter
	long onUpdDelimiter(FXObject*,FXSelector,void*);
	/// The Quote delimiter front value changed
	long onCmdDelimiterFront(FXObject*,FXSelector,void*);
	/// Display the Quote delimiter front
	long onUpdDelimiterFront(FXObject*,FXSelector,void*);
	/// The Quote delimiter back value changed
	long onCmdDelimiterBack(FXObject*,FXSelector,void*);
	/// Display the Quote delimiter back
	long onUpdDelimiterBack(FXObject*,FXSelector,void*);
	/// Update the control
	long onUpdEnableFTP(FXObject*,FXSelector,void*);
	/// Show FTP dialog
	long onCmdShowFTP(FXObject*,FXSelector,void*);
	void appendLog(const FXString i_str);

	long onCmdSETICancel(FXObject*,FXSelector,void*);
	long onCmdOK(FXObject*,FXSelector,void*);

  enum{
	ID_CHKONCETHENEXIT=FXMainWindow::ID_LAST,
	ID_CHKENABLESIG,
	ID_CHKENABLEHTML,
	ID_CHKENABLEFTP,
	ID_TXTFLDUSERINFO,
	ID_BTNDEFAULTLOCATION,
	ID_CHKSETIHIDE,
	ID_TXTFLDINPUTSIG,
	ID_TXTFLDOUTPUTSIG,
	ID_TXTFLDINPUTHTML,
	ID_TXTFLDOUTPUTHTML,
	ID_TXTFLDOUTPUTFTP,
	ID_TXTFLDQUOTE,
	ID_BTNUSERINFO,
	ID_BTNINPUTSIG,
	ID_BTNOUTPUTSIG,
	ID_BTNINPUTHTML,
	ID_BTNOUTPUTHTML,
	ID_BTNOUTPUTFTP,
	ID_BTNBROWSEQUOTE,
	ID_TXTFLDTIMESIG,
	ID_TXTFLDTIMEHTML,
	ID_SETUSERINFO,
	ID_SETSIGINPUT,
	ID_SETSIGOUTPUT,
	ID_SETHTMLINPUT,
	ID_SETHTMLOUTPUT,
	ID_TXTFLDDELIMITER,
	ID_TXTFLDDELIMITERFRONT,
	ID_TXTFLDDELIMITERBACK,
	ID_BTNOK,
	ID_BTNCANCEL
  };

protected:
	void	CopySettings(FXSettings * o_pTo, const FXSettings * i_pFrom);

	/// Add an entry to the log window
	void Log(FXString i_str);

	// Go from what the user can read to actual values
	FXbool parseValue(FXchar* value,const FXchar* buffer);
	// Go from actual characters to something the user can read and edit
	FXbool unparseValue(FXchar* buffer,const FXchar* value);

protected:
	FXSettings		*	m_pOriginalSettings;
	FXSettings		*	m_pCurrentSettings;
	FTPSettings		*	m_pFTPSettings;

	FXCheckButton*		m_chkOnceThenExit;
	FXCheckButton*		m_chkSetiHide;
	FXTextField*		m_txtfldUserInfo;
	FXButton*			m_btnDefaultLocation;
	FXTextField*		m_txtfldInputSig;
	FXTextField*		m_txtfldOutputSig;
	FXTextField*		m_txtfldInputHTML;
	FXTextField*		m_txtfldOutputHTML;
	FXTextField*		m_txtfldOutputFTP;	// non-editable
	FXTextField*		m_txtfldInputQuote;
	FXTextField*		m_txtfldDelimiter;
	FXTextField*		m_txtfldDelimiterFront;
	FXTextField*		m_txtfldDelimiterBack;
	FXButton*			m_btnBrowseUserInfo;
	FXButton*			m_btnBrowseInputSig;
	FXButton*			m_btnBrowseOutputSig;
	FXButton*			m_btnBrowseInputHTML;
	FXButton*			m_btnBrowseOutputHTML;
	FXButton*			m_btnConfigOutputFTP;
	FXButton*			m_btnBrowseQuote;
	FXTextField*		m_txtfldTimeSig;
	FXTextField*		m_txtfldTimeHTML;
	FXCheckButton*		m_chkEnableSig;
	FXCheckButton*		m_chkEnableHTML;
	FXCheckButton*		m_chkEnableFTP;		// Dupe of field in FTP dialog

	// Needed for debug/log output
	DebugDialog*		m_pdialogDebug;

	FXButton		*	m_pbtnOK;
	FXButton		*	m_pbtnCancel;

private:
	MainConfigDialog(){}
};
