/********************************************************************************
*                                                                               *
*                        MainConfigDlg Class                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: MainConfigDlg.cpp,v 1.00 2003/01/16 Exp $                                *
********************************************************************************/

#include "xincs.h"	// Fox include
#include "fx.h"
#include "FXSettings.h"

#include "SETIConsts.h"
#include "SETIFTPSettings.h"
#include "FTPConfigDlg.h"
#include "DebugDlg.h"
#include "MainConfigDlg.h"

// Arbitrary max size of delimiter
#define MAXDELIMITER 2000

//---------------------------------------------------------------------------
// FXTestDialog implementation
FXDEFMAP(MainConfigDialog) MainConfigDialogMap[]={
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_CHKONCETHENEXIT, MainConfigDialog::onCmdOnceThenExit),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_CHKONCETHENEXIT, MainConfigDialog::onUpdOnceThenExit),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_CHKSETIHIDE, MainConfigDialog::onCmdSetiHide),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_CHKSETIHIDE, MainConfigDialog::onUpdSetiHide),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_SETUSERINFO, MainConfigDialog::onCmdBrowseUserInfo),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDUSERINFO, MainConfigDialog::onCmdUserInfo),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDUSERINFO, MainConfigDialog::onUpdUserInfo),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNDEFAULTLOCATION, MainConfigDialog::onCmdDefaultLocation),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_SETSIGINPUT, MainConfigDialog::onCmdBrowseSigIn),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDINPUTSIG, MainConfigDialog::onCmdSigIn),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDINPUTSIG, MainConfigDialog::onUpdSigIn),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_SETSIGOUTPUT, MainConfigDialog::onCmdBrowseSig),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDOUTPUTSIG, MainConfigDialog::onCmdSig),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDOUTPUTSIG, MainConfigDialog::onUpdSig),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_SETHTMLINPUT, MainConfigDialog::onCmdBrowseHTMLIn),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDINPUTHTML, MainConfigDialog::onCmdHTMLIn),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDINPUTHTML, MainConfigDialog::onUpdHTMLIn),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_SETHTMLOUTPUT, MainConfigDialog::onCmdBrowseHTML),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDOUTPUTHTML, MainConfigDialog::onCmdHTML),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDOUTPUTHTML, MainConfigDialog::onUpdHTML),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNUSERINFO, MainConfigDialog::onCmdBrowseUserInfo),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNINPUTSIG, MainConfigDialog::onCmdBrowseSigIn),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNOUTPUTSIG, MainConfigDialog::onCmdBrowseSig),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNINPUTHTML, MainConfigDialog::onCmdBrowseHTMLIn),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNOUTPUTHTML, MainConfigDialog::onCmdBrowseHTML),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDOUTPUTFTP, MainConfigDialog::onUpdFTP),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNOUTPUTFTP, MainConfigDialog::onCmdShowFTP),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDQUOTE, MainConfigDialog::onUpdQuote),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNBROWSEQUOTE, MainConfigDialog::onCmdBrowseQuote),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_CHKENABLESIG, MainConfigDialog::onCmdEnableSig),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_CHKENABLESIG, MainConfigDialog::onUpdEnableSig),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_CHKENABLEHTML, MainConfigDialog::onCmdEnableHTML),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_CHKENABLEHTML, MainConfigDialog::onUpdEnableHTML),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_CHKENABLEFTP, MainConfigDialog::onCmdEnableFTP),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_CHKENABLEFTP, MainConfigDialog::onUpdEnableFTP),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDTIMESIG, MainConfigDialog::onCmdTimeSig),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDTIMESIG, MainConfigDialog::onUpdTimeSig),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDTIMEHTML, MainConfigDialog::onCmdTimeHTML),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDTIMEHTML, MainConfigDialog::onUpdTimeHTML),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDDELIMITER, MainConfigDialog::onCmdDelimiter),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDDELIMITER, MainConfigDialog::onUpdDelimiter),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDDELIMITERFRONT, MainConfigDialog::onCmdDelimiterFront),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDDELIMITERFRONT, MainConfigDialog::onUpdDelimiterFront),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_TXTFLDDELIMITERBACK, MainConfigDialog::onCmdDelimiterBack),
  FXMAPFUNC(SEL_UPDATE, MainConfigDialog::ID_TXTFLDDELIMITERBACK, MainConfigDialog::onUpdDelimiterBack),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNOK, MainConfigDialog::onCmdOK),
  FXMAPFUNC(SEL_COMMAND, MainConfigDialog::ID_BTNCANCEL, MainConfigDialog::onCmdSETICancel),
  };

FXIMPLEMENT(MainConfigDialog,FXDialogBox,MainConfigDialogMap,ARRAYNUMBER(MainConfigDialogMap))

//---------------------------------------------------------------------------
// Construct a dialog box
MainConfigDialog::MainConfigDialog(FXWindow* owner, FXSettings * i_pSettings,
		FTPSettings * i_pFTPSettings, DebugDialog * i_pdialogDebug):
  FXDialogBox(owner,"Main Settings",DECOR_ALL & ~(DECOR_MINIMIZE | DECOR_MAXIMIZE | DECOR_CLOSE | DECOR_RESIZE), 0, 0, 600, 360),
		m_chkOnceThenExit(NULL),
		m_chkSetiHide(NULL),
		m_txtfldUserInfo(NULL),
		m_btnDefaultLocation(NULL),
		m_txtfldInputSig(NULL),
		m_txtfldOutputSig(NULL),
		m_txtfldInputHTML(NULL),
		m_txtfldOutputHTML(NULL),
		m_txtfldOutputFTP(NULL),
		m_txtfldInputQuote(NULL),
		m_txtfldDelimiter(NULL),
		m_txtfldDelimiterFront(NULL),
		m_txtfldDelimiterBack(NULL),
		m_btnBrowseUserInfo(NULL),
		m_btnBrowseInputSig(NULL),
		m_btnBrowseOutputSig(NULL),
		m_btnBrowseInputHTML(NULL),
		m_btnBrowseOutputHTML(NULL),
		m_btnConfigOutputFTP(NULL),
		m_btnBrowseQuote(NULL),
		m_txtfldTimeSig(NULL),
		m_txtfldTimeHTML(NULL),
		m_chkEnableSig(NULL),
		m_chkEnableHTML(NULL),
		m_chkEnableFTP(NULL),
	m_pOriginalSettings(NULL),
	m_pCurrentSettings(i_pSettings),
	m_pFTPSettings(i_pFTPSettings),
	m_pdialogDebug(i_pdialogDebug)
{
m_pOriginalSettings = new FXSettings;
CopySettings(m_pOriginalSettings, i_pSettings);

FXVerticalFrame * l_frameMain = new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);

FXHorizontalFrame * l_frameHoriz = new FXHorizontalFrame(l_frameMain, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
m_chkOnceThenExit = new FXCheckButton(l_frameHoriz, "Update Once then exit\t\tAfter writing the files, wait a few seconds then quit", this, ID_CHKONCETHENEXIT);
m_chkSetiHide = new FXCheckButton(l_frameHoriz, "Using SetiHide\t\tNeed to look in wu_cache_* folders for user_info.sah", this, ID_CHKSETIHIDE);

	const FXint lk_nWidth = 60;
	// Make input text field and browse button
	l_frameHoriz = new FXHorizontalFrame(l_frameMain, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	FXLabel * l_lblTemp = new FXLabel(l_frameHoriz, "Input SETI@Home", NULL, LABEL_NORMAL, 0,0,95,0,20);
	m_txtfldUserInfo = new FXTextField(l_frameHoriz, lk_nWidth, this, ID_TXTFLDUSERINFO);
	m_btnBrowseUserInfo = new FXButton(l_frameHoriz, "...\t\tFind input file", NULL, this, ID_BTNUSERINFO);
	m_btnDefaultLocation = new FXButton(l_frameHoriz, "Default\t\tFill in default folder location", NULL, this, ID_BTNDEFAULTLOCATION);

	// Make text field with config and enable buttons for Sig
	FXVerticalFrame * l_frameVert = new FXVerticalFrame(l_frameMain, FRAME_LINE|LAYOUT_FILL_X);
	// Input
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Input Sig Template", NULL, LABEL_NORMAL, 0,0,0,0,17);
	m_txtfldInputSig = new FXTextField(l_frameHoriz, lk_nWidth, this, ID_TXTFLDINPUTSIG);
	m_btnBrowseInputSig = new FXButton(l_frameHoriz, "...\t\tChoose input sig template", NULL, this, ID_BTNINPUTSIG);
	m_chkEnableSig = new FXCheckButton(l_frameHoriz, "Enabled", this, ID_CHKENABLESIG);
	// Output
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Output Sig", NULL, LABEL_NORMAL, 0,0,95,0,56);
	m_txtfldOutputSig = new FXTextField(l_frameHoriz, lk_nWidth, this, ID_TXTFLDOUTPUTSIG);
	m_btnBrowseOutputSig = new FXButton(l_frameHoriz, "...\t\tChoose output sig file", NULL, this, ID_BTNOUTPUTSIG);

	// Make text field with config and enable buttons for HTML
	l_frameVert = new FXVerticalFrame(l_frameMain, FRAME_LINE|LAYOUT_FILL_X);
	// Input
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Input HTML Template", NULL, LABEL_NORMAL, 0,0,95,0,2);
	m_txtfldInputHTML = new FXTextField(l_frameHoriz, lk_nWidth, this, ID_TXTFLDINPUTHTML);
	m_btnBrowseInputHTML = new FXButton(l_frameHoriz, "...\t\tChoose input HTML file", NULL, this, ID_BTNINPUTHTML);
	m_chkEnableHTML = new FXCheckButton(l_frameHoriz, "Enabled", this, ID_CHKENABLEHTML);
	// Output
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Output HTML", NULL, LABEL_NORMAL, 0,0,95,0,41);
	m_txtfldOutputHTML = new FXTextField(l_frameHoriz, lk_nWidth, this, ID_TXTFLDOUTPUTHTML);
	m_btnBrowseOutputHTML = new FXButton(l_frameHoriz, "...\t\tChoose output HTML file", NULL, this, ID_BTNOUTPUTHTML);

	// Make display text field with config and enable buttons for FTP
	l_frameHoriz = new FXHorizontalFrame(l_frameMain, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Output FTP", NULL, LABEL_NORMAL, 0,0,95,0,54);
	m_txtfldOutputFTP = new FXTextField(l_frameHoriz, lk_nWidth-7, this, ID_TXTFLDOUTPUTFTP);
	m_btnConfigOutputFTP = new FXButton(l_frameHoriz, " Configure \t\tDefine FTP server", NULL, this, ID_BTNOUTPUTFTP);
	m_chkEnableFTP = new FXCheckButton(l_frameHoriz, "Enabled", this, ID_CHKENABLEFTP);

	// Make display text field with browse button for Quote text
	l_frameVert = new FXVerticalFrame(l_frameMain, FRAME_LINE|LAYOUT_FILL_X);
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Quote text", NULL, LABEL_NORMAL, 0,0,95,0,57);
	m_txtfldInputQuote = new FXTextField(l_frameHoriz, lk_nWidth-7, this, ID_TXTFLDQUOTE);
	m_btnBrowseQuote = new FXButton(l_frameHoriz, "...\t\tChoose input file", NULL, this, ID_BTNBROWSEQUOTE);
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Quote Delimiter", NULL, LABEL_NORMAL, 0,0,95,0,34);
	m_txtfldDelimiter = new FXTextField(l_frameHoriz, 12, this, ID_TXTFLDDELIMITER);
	l_lblTemp = new FXLabel(l_frameHoriz, "Adjust Front", NULL, LABEL_NORMAL);
	m_txtfldDelimiterFront = new FXTextField(l_frameHoriz, 3, this, ID_TXTFLDDELIMITERFRONT, TEXTFIELD_NORMAL | TEXTFIELD_INTEGER | LAYOUT_LEFT);
	l_lblTemp = new FXLabel(l_frameHoriz, "Adjust Back", NULL, LABEL_NORMAL);
	m_txtfldDelimiterBack = new FXTextField(l_frameHoriz, 3, this, ID_TXTFLDDELIMITERBACK, TEXTFIELD_NORMAL | TEXTFIELD_INTEGER | LAYOUT_LEFT);

	// Time fields
	l_frameVert = new FXVerticalFrame(l_frameMain, FRAME_LINE);
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, FRAME_NONE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "Sig", NULL, LABEL_NORMAL, 0,0,95,0,17);
	m_txtfldTimeSig = new FXTextField(l_frameHoriz, 12, this, ID_TXTFLDTIMESIG, TEXTFIELD_NORMAL | TEXTFIELD_INTEGER | LAYOUT_LEFT);
	l_lblTemp = new FXLabel(l_frameHoriz, "seconds (86400 = 24 hours)", NULL, LABEL_NORMAL | LAYOUT_LEFT);
	l_frameHoriz = new FXHorizontalFrame(l_frameVert, FRAME_NONE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
	l_lblTemp = new FXLabel(l_frameHoriz, "HTML", NULL, LABEL_NORMAL | LAYOUT_LEFT);
	m_txtfldTimeHTML = new FXTextField(l_frameHoriz, 12, this, ID_TXTFLDTIMEHTML, TEXTFIELD_NORMAL | TEXTFIELD_INTEGER | LAYOUT_LEFT);
	l_lblTemp = new FXLabel(l_frameHoriz, "seconds (300 = 5 minutes)", NULL, LABEL_NORMAL | LAYOUT_LEFT);

// OK and Cancel buttons
l_frameHoriz = new FXHorizontalFrame(l_frameMain, FRAME_LINE|LAYOUT_RIGHT,0,0,0,0, 0,0,0,0);
m_pbtnOK = new FXButton(l_frameHoriz, "OK", NULL, this, ID_BTNOK);
m_pbtnCancel = new FXButton(l_frameHoriz, "Cancel", NULL, this, ID_BTNCANCEL);
}

//---------------------------------------------------------------------------
// Must delete the menus
MainConfigDialog::~MainConfigDialog()
{
}

//---------------------------------------------------------------------------
FXuint MainConfigDialog::execute(FXuint placement)
{
CopySettings(m_pOriginalSettings, m_pCurrentSettings);
return FXDialogBox::execute(placement);
}

//---------------------------------------------------------------------------
void MainConfigDialog::show()
{
CopySettings(m_pOriginalSettings, m_pCurrentSettings);
FXDialogBox::show();
}

//---------------------------------------------------------------------------
// Enable/disable Once then exit
long MainConfigDialog::onCmdOnceThenExit(FXObject*,FXSelector,void*)
{
	Log("onCmdOnceThenExit");
	// Toggle it here
	FXint l_fOnceThenExit = m_chkOnceThenExit->getCheck();
	m_pCurrentSettings->writeIntEntry("System", "UpdateOnceThenExit", l_fOnceThenExit);
////	WriteINI();
	return 1;
}

//---------------------------------------------------------------------------
// Update check state of Once then exit
long MainConfigDialog::onUpdOnceThenExit(FXObject*,FXSelector,void*)
{
	FXint l_fOnceThenExit = m_pCurrentSettings->readIntEntry("System", "UpdateOnceThenExit", k_fDefaultUpdateOnceThenExit);
	m_chkOnceThenExit->setCheck(l_fOnceThenExit);
	return 1;
}

//---------------------------------------------------------------------------
// Enable/disable Using SetiHide
long MainConfigDialog::onCmdSetiHide(FXObject*,FXSelector,void*)
{
	Log("onCmdSetiHide");
	// Toggle it here
	FXint l_fSetiHide = m_chkSetiHide->getCheck();
	m_pCurrentSettings->writeIntEntry("System", "UsingSetiHide", l_fSetiHide);
////	WriteINI();
	return 1;
}

//---------------------------------------------------------------------------
// Update check state of Using SetiHide
long MainConfigDialog::onUpdSetiHide(FXObject*,FXSelector,void*)
{
	FXint l_fSetiHide = m_pCurrentSettings->readIntEntry("System", "UsingSetiHide", k_fDefaultUsingSetiHide);
	m_chkSetiHide->setCheck(l_fSetiHide);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdBrowseUserInfo(FXObject*,FXSelector,void*)
{
	FXString l_strTemp;
	Log("onCmdBrowseUserInfo");
	FXString l_strFile;
	l_strTemp = m_pCurrentSettings->readStringEntry("Machines", "Root", k_arrcUserInfo);
	FXDirDialog l_dir(this, l_strTemp);
	l_dir.setDirectory(l_strTemp);
	if ( l_dir.execute() )
		{
		l_strFile=l_dir.getDirectory();
		m_pCurrentSettings->writeStringEntry("Machines", "Root", l_strFile.text());
		}
	// TODO: Should really test to see if we're not using Setihide.
	// Because if not, then there should be a user_info here
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdUserInfo(FXObject*,FXSelector,void*)
{
	FXString l_str = m_txtfldUserInfo->getText();
	m_pCurrentSettings->writeStringEntry("Machines", "Root", l_str.text());
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdUserInfo(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcFilename;
	lk_pcFilename = m_pCurrentSettings->readStringEntry("Machines", "Root", k_arrcUserInfo);
	m_txtfldUserInfo->setText(lk_pcFilename);
	return 1;
}

//---------------------------------------------------------------------------
// Choose output file
long MainConfigDialog::onCmdBrowseSigIn(FXObject*,FXSelector,void*)
{
	FXString l_strTemp;
	Log("onCmdBrowseSigIn");
	FXString l_strFile;
	FXFileDialog opendialog(this,"Choose input sig file");
	opendialog.setSelectMode( SELECTFILE_ANY );
	opendialog.setPatternList("*.txt,*.sig,*.*");
	opendialog.setFilename( k_arrcDefaultSigInputName );
	if(opendialog.execute())
		{
		l_strFile=opendialog.getFilename();
		m_pCurrentSettings->writeStringEntry("Sig", "Input", l_strFile.text());
		}
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdSigIn(FXObject*,FXSelector,void*)
{
	FXString l_str = m_txtfldInputSig->getText();
	m_pCurrentSettings->writeStringEntry("Sig", "Input", l_str.text());
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdSigIn(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcSigFilename;
	lk_pcSigFilename = m_pCurrentSettings->readStringEntry("Sig", "Input", k_arrcDefaultSigInputName);
	m_txtfldInputSig->setText(lk_pcSigFilename);
	return 1;
}

//---------------------------------------------------------------------------
// Choose output file
long MainConfigDialog::onCmdBrowseSig(FXObject*,FXSelector,void*)
{
	FXString l_strTemp;
	Log("onCmdBrowseSig");
	FXString l_strFile;
	FXFileDialog opendialog(this,"Choose output sig file");
	opendialog.setSelectMode( SELECTFILE_ANY );
	opendialog.setPatternList("*.txt,*.sig,*.*");
	opendialog.setFilename( k_arrcDefaultSigName );
	if(opendialog.execute())
		{
		l_strFile=opendialog.getFilename();
		m_pCurrentSettings->writeStringEntry("Sig", "Output", l_strFile.text());
		}
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdSig(FXObject*,FXSelector,void*)
{
	FXString l_str = m_txtfldOutputSig->getText();
	m_pCurrentSettings->writeStringEntry("Sig", "Output", l_str.text());
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdSig(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcSigFilename;
	lk_pcSigFilename = m_pCurrentSettings->readStringEntry("Sig", "Output", k_arrcDefaultSigName);
	m_txtfldOutputSig->setText(lk_pcSigFilename);
	return 1;
}

//---------------------------------------------------------------------------
// Choose input file
long MainConfigDialog::onCmdBrowseHTMLIn(FXObject*,FXSelector,void*)
{
	FXString l_strTemp;
	Log("onCmdBrowseHTMLIn");
	FXString l_strFile;
	FXFileDialog opendialog(this,"Choose input HTML file");
	opendialog.setSelectMode( SELECTFILE_ANY );
	opendialog.setPatternList("*.htm,*.html,*.*");
	opendialog.setFilename( k_arrcDefaultHTMLInputName );
	if(opendialog.execute())
		{
		l_strFile=opendialog.getFilename();
		m_pCurrentSettings->writeStringEntry("HTML", "Input", l_strFile.text());
		}
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdHTMLIn(FXObject*,FXSelector,void*)
{
	FXString l_str = m_txtfldInputHTML->getText();
	m_pCurrentSettings->writeStringEntry("HTML", "Input", l_str.text());
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdHTMLIn(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcHTMLFilename;
	lk_pcHTMLFilename = m_pCurrentSettings->readStringEntry("HTML", "Input", k_arrcDefaultHTMLInputName);
	m_txtfldInputHTML->setText(lk_pcHTMLFilename);
	return 1;
}

//---------------------------------------------------------------------------
// Choose output file
long MainConfigDialog::onCmdBrowseHTML(FXObject*,FXSelector,void*)
{
	FXString l_strTemp;
	Log("onCmdBrowseHTML");
	FXString l_strFile;
	FXFileDialog opendialog(this,"Choose output HTML file");
	opendialog.setSelectMode( SELECTFILE_ANY );
	opendialog.setPatternList("*.htm,*.html,*.*");
	opendialog.setFilename( k_arrcDefaultHTMLName );
	if(opendialog.execute())
		{
		l_strFile=opendialog.getFilename();
		m_pCurrentSettings->writeStringEntry("HTML", "Output", l_strFile.text());
		}
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdHTML(FXObject*,FXSelector,void*)
{
	FXString l_str = m_txtfldOutputHTML->getText();
	m_pCurrentSettings->writeStringEntry("HTML", "Output", l_str.text());
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdHTML(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcHTMLFilename;
	lk_pcHTMLFilename = m_pCurrentSettings->readStringEntry("HTML", "Output", k_arrcDefaultHTMLName);
	m_txtfldOutputHTML->setText(lk_pcHTMLFilename);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdFTP(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcFilename;
	lk_pcFilename = m_pCurrentSettings->readStringEntry("FTP", "Server", k_arrcDefaultFTPServer);
	m_txtfldOutputFTP->setText(lk_pcFilename);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdShowFTP(FXObject*,FXSelector,void*)
{
	m_txtfldOutputFTP->setText(m_pFTPSettings->m_strServer);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdShowFTP(FXObject*,FXSelector,void*)
{
	FTPConfigDialog *l_pdialogFTP = new FTPConfigDialog(this, m_pFTPSettings);
	l_pdialogFTP->execute(PLACEMENT_OWNER);
	// Saving done by main window
	delete l_pdialogFTP;
	l_pdialogFTP = NULL;
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdQuote(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcFilename;
	lk_pcFilename = m_pCurrentSettings->readStringEntry("Quotes", "Input", k_arrcDefaultQuote);
	m_txtfldInputQuote->setText(lk_pcFilename);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdBrowseQuote(FXObject*,FXSelector,void*)
{
	FXString l_strTemp;
	Log("onCmdBrowseQuote");
	FXString l_strFile;
	FXFileDialog opendialog(this,"Choose input Quote file");
	opendialog.setSelectMode( SELECTFILE_ANY );
	opendialog.setPatternList("*.txt,*.*");
	opendialog.setFilename( k_arrcDefaultQuote );
	if(opendialog.execute())
		{
		l_strFile=opendialog.getFilename();
		m_pCurrentSettings->writeStringEntry("Quotes", "Input", l_strFile.text());
		}
	return 1;
}

//---------------------------------------------------------------------------
// Enable/disable Sig file output
long MainConfigDialog::onCmdEnableSig(FXObject*,FXSelector,void*)
{
	Log("onCmdEnableSig");
	// Toggle it here
	FXint l_fSigEnabled = m_chkEnableSig->getCheck();
	m_pCurrentSettings->writeIntEntry("Sig", "Enabled", l_fSigEnabled);
	return 1;
}

//---------------------------------------------------------------------------
// Enable/disable Sig file output
long MainConfigDialog::onUpdEnableSig(FXObject*,FXSelector,void*)
{
	FXint l_fSigEnabled = m_pCurrentSettings->readIntEntry("Sig", "Enabled", TRUE);
	m_chkEnableSig->setCheck(l_fSigEnabled);
	return 1;
}

//---------------------------------------------------------------------------
// Enable/disable HTML file output
long MainConfigDialog::onCmdEnableHTML(FXObject*,FXSelector,void*)
{
	Log("onCmdEnableHTML");
	// Toggle it here
	FXint l_fHTMLEnabled = m_chkEnableHTML->getCheck();
	m_pCurrentSettings->writeIntEntry("HTML", "Enabled", l_fHTMLEnabled);
	return 1;
}

//---------------------------------------------------------------------------
// Enable/disable HTML file output
long MainConfigDialog::onUpdEnableHTML(FXObject*,FXSelector,void*)
{
	FXint l_fHTMLEnabled = m_pCurrentSettings->readIntEntry("HTML", "Enabled", TRUE);
	m_chkEnableHTML->setCheck(l_fHTMLEnabled);
	return 1;
}

//---------------------------------------------------------------------------
// Enable/disable FTP file output
long MainConfigDialog::onCmdEnableFTP(FXObject*,FXSelector,void*)
{
	Log("onCmdEnableFTP");
	// Toggle it here
	FXint l_fFTPEnabled = m_chkEnableFTP->getCheck();
	m_pFTPSettings->m_fEnabled = l_fFTPEnabled;
	m_pCurrentSettings->writeIntEntry("FTP", "Enabled", l_fFTPEnabled);
	return 1;
}

//---------------------------------------------------------------------------
// Enable/disable FTP file output
long MainConfigDialog::onUpdEnableFTP(FXObject*,FXSelector,void*)
{
	FXint l_fFTPEnabled = m_pCurrentSettings->readIntEntry("FTP", "Enabled", TRUE);
	m_chkEnableFTP->setCheck(l_fFTPEnabled);
	return 1;
}

//---------------------------------------------------------------------------
// The sig time value changed
long MainConfigDialog::onCmdTimeSig(FXObject*sender,FXSelector,void*)
{
	Log("onCmdTimeSig");
	FXint l_nTime = 0;
	sender->handle(this,MKUINT(ID_GETINTVALUE,SEL_COMMAND),(void*)&l_nTime);
	m_pCurrentSettings->writeIntEntry("Sig", "Interval", l_nTime);
	return 1;
}

//---------------------------------------------------------------------------
// Display the Sig time value
long MainConfigDialog::onUpdTimeSig(FXObject*sender,FXSelector,void*)
{
	FXint l_nTime = m_pCurrentSettings->readIntEntry("Sig", "Interval", 86400);
	sender->handle(this,MKUINT(ID_SETINTVALUE,SEL_COMMAND),(void*)&l_nTime);
	return 1;
}

//---------------------------------------------------------------------------
// HTML time value changed
long MainConfigDialog::onCmdTimeHTML(FXObject*sender,FXSelector,void*)
{
	Log("onCmdTimeHTML");
	FXint l_nTime = 0;
	sender->handle(this,MKUINT(ID_GETINTVALUE,SEL_COMMAND),(void*)&l_nTime);
	m_pCurrentSettings->writeIntEntry("HTML", "Interval", l_nTime);
	return 1;
}

//---------------------------------------------------------------------------
// Display the HTML time value
long MainConfigDialog::onUpdTimeHTML(FXObject*sender,FXSelector,void*)
{
	FXint l_nTime = m_pCurrentSettings->readIntEntry("HTML", "Interval", 86400);
	sender->handle(this,MKUINT(ID_SETINTVALUE,SEL_COMMAND),(void*)&l_nTime);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdDelimiter(FXObject*,FXSelector,void*)
{
	FXString l_str = m_txtfldDelimiter->getText();
	FXchar l_arrc[MAXDELIMITER];
	parseValue(l_arrc, l_str.text());
	m_pCurrentSettings->writeStringEntry("Quotes", "Delimiter", l_arrc);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onUpdDelimiter(FXObject*,FXSelector,void*)
{
	const FXchar* lk_pcDelimiter;
	lk_pcDelimiter = m_pCurrentSettings->readStringEntry("Quotes", "Delimiter", k_arrcQuoteDelimiter);
	FXchar l_arrc[MAXDELIMITER];
	FXbool l_fNeedQuotes = unparseValue(l_arrc, lk_pcDelimiter);
	FXString l_str;
	if ( l_fNeedQuotes )
		l_str = FXString("\"") + FXString(l_arrc) + FXString("\"");
	else
		l_str = FXString(l_arrc);
	m_txtfldDelimiter->setText(l_str);
	return 1;
}

//---------------------------------------------------------------------------
// The quote delimiter front changed
long MainConfigDialog::onCmdDelimiterFront(FXObject*sender,FXSelector,void*)
{
	Log("onCmdDelimiterFront");
	FXint l_Num = 0;
	sender->handle(this,MKUINT(ID_GETINTVALUE,SEL_COMMAND),(void*)&l_Num);
	m_pCurrentSettings->writeIntEntry("Quotes", "DelimiterAdjustFront", l_Num);
	return 1;
}

//---------------------------------------------------------------------------
// Display the delimiter front value
long MainConfigDialog::onUpdDelimiterFront(FXObject*sender,FXSelector,void*)
{
	FXint l_Num = m_pCurrentSettings->readIntEntry("Quotes", "DelimiterAdjustFront", 0);
	sender->handle(this,MKUINT(ID_SETINTVALUE,SEL_COMMAND),(void*)&l_Num);
	return 1;
}

//---------------------------------------------------------------------------
// The quote delimiter back changed
long MainConfigDialog::onCmdDelimiterBack(FXObject*sender,FXSelector,void*)
{
	Log("onCmdDelimiterBack");
	FXint l_Num = 0;
	sender->handle(this,MKUINT(ID_GETINTVALUE,SEL_COMMAND),(void*)&l_Num);
	m_pCurrentSettings->writeIntEntry("Quotes", "DelimiterAdjustBack", l_Num);
	return 1;
}

//---------------------------------------------------------------------------
// Display the delimiter back value
long MainConfigDialog::onUpdDelimiterBack(FXObject*sender,FXSelector,void*)
{
	FXint l_Num = m_pCurrentSettings->readIntEntry("Quotes", "DelimiterAdjustBack", 0);
	sender->handle(this,MKUINT(ID_SETINTVALUE,SEL_COMMAND),(void*)&l_Num);
	return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdOK(FXObject* o,FXSelector s,void* v)
{
CopySettings(m_pOriginalSettings, m_pCurrentSettings);
// I shouldn't have to call this directly.  Need to figure out how to send message
onCmdAccept(o,s,v);
//handle(this,MKUINT(SEL_COMMAND,ID_ACCEPT),NULL);
//hide();
return 1;
}

//---------------------------------------------------------------------------
long MainConfigDialog::onCmdSETICancel(FXObject* o,FXSelector s,void* v)
{
CopySettings(m_pCurrentSettings, m_pOriginalSettings);
onCmdCancel(o,s,v);
//handle(this,MKUINT(SEL_COMMAND,ID_CANCEL),NULL);
//hide();
return 1;
}

//---------------------------------------------------------------------------
void MainConfigDialog::CopySettings(FXSettings * o_pTo, const FXSettings * i_pFrom)
{
FXint l_nOuterIndex = i_pFrom->first();
if ( i_pFrom->size() > l_nOuterIndex )
	{
	while ( i_pFrom->size() > l_nOuterIndex )
		{
		FXStringDict * l_pDict = i_pFrom->data(l_nOuterIndex);
		FXint l_nInnerIndex = l_pDict->first();
		if ( l_pDict->size() > l_nInnerIndex )
			{
			while ( l_pDict->size() > l_nInnerIndex )
				{
				const FXchar * l_psOuterKey = i_pFrom->key(l_nOuterIndex);
				const FXchar * l_psInnerKey = l_pDict->key(l_nInnerIndex);
				const FXchar * l_psValue = l_pDict->data(l_nInnerIndex);
				o_pTo->writeStringEntry(l_psOuterKey, l_psInnerKey, l_psValue);
				l_nInnerIndex = l_pDict->next(l_nInnerIndex);
				}
			l_nOuterIndex = i_pFrom->next(l_nOuterIndex);
			}
// else
// error message should not occur
		}
	}
// else
// error message should not occur
}

//---------------------------------------------------------------------------
void MainConfigDialog::Log(FXString i_str)
{
	appendLog(i_str);
	appendLog("\n");
}

//---------------------------------------------------------------------------
void MainConfigDialog::appendLog(const FXString i_str)
{
	m_pdialogDebug->AppendLog(i_str);
}

//---------------------------------------------------------------------------
// Choose input file
long MainConfigDialog::onCmdDefaultLocation(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->writeStringEntry("Machines", "Root", k_arrcUserInfo);
return 1;
}

//---------------------------------------------------------------------------
// Parse value
FXbool MainConfigDialog::parseValue(FXchar* value,const FXchar* buffer){
  register const FXchar *ptr=buffer;
  register FXchar *out=value;
  unsigned int v1,v2,h,l;

  // Was quoted string; copy verbatim
  if(*ptr=='"'){
    ptr++;
    while(*ptr){
      switch(*ptr){
        case '\\':
          ptr++;
          switch(*ptr){
            case 'n':
              *out++='\n';
              break;
            case 'r':
              *out++='\r';
              break;
            case 'b':
              *out++='\b';
              break;
            case 'v':
              *out++='\v';
              break;
            case 'a':
              *out++='\a';
              break;
            case 'f':
              *out++='\f';
              break;
            case 't':
              *out++='\t';
              break;
            case '\\':
              *out++='\\';
              break;
            case '"':
              *out++='"';
              break;
            case 'x':
              ptr++;
              v1=*ptr++;
              if(!v1) return FALSE;
              v2=*ptr;
              if(!v2) return FALSE;
              h=v1<='9'?v1-'0':toupper(v1)-'A'+10;
              l=v2<='9'?v2-'0':toupper(v2)-'A'+10;
              *out++=(h<<4)+l;
              break;
            default:
              *out++=*ptr;
              break;
            }
          break;
        case '"':
          *out='\0';
          return TRUE;
        default:
          *out++=*ptr;
          break;
        }
      ptr++;
      }
    *value='\0';
    return FALSE;
    }

  // Non-quoted string copy sequence of non-white space
  else{
    while(*ptr && !isspace((FXuchar)*ptr) && isprint((FXuchar)*ptr)){
      *out++=*ptr++;
      }
    *out='\0';
    }
  return TRUE;
  }


//---------------------------------------------------------------------------
// Unparse value by quoting strings; return TRUE if quote needed
FXbool MainConfigDialog::unparseValue(FXchar* buffer,const FXchar* value){
  const FXchar hex[]="0123456789ABCDEF";
  register FXchar *ptr=buffer;
  register FXbool mustquote=FALSE;
  register FXuint v;
  FXASSERT(value);
  while(*value && ptr<&buffer[MAXDELIMITER-5]){
    switch(*value){
      case '\n':
        *ptr++='\\';
        *ptr++='n';
        mustquote=TRUE;
        break;
      case '\r':
        *ptr++='\\';
        *ptr++='r';
        mustquote=TRUE;
        break;
      case '\b':
        *ptr++='\\';
        *ptr++='b';
        mustquote=TRUE;
        break;
      case '\v':
        *ptr++='\\';
        *ptr++='v';
        mustquote=TRUE;
        break;
      case '\a':
        *ptr++='\\';
        *ptr++='a';
        mustquote=TRUE;
        break;
      case '\f':
        *ptr++='\\';
        *ptr++='f';
        mustquote=TRUE;
        break;
      case '\t':
        *ptr++='\\';
        *ptr++='t';
        mustquote=TRUE;
        break;
      case '\\':
        *ptr++='\\';
        *ptr++='\\';
        mustquote=TRUE;
        break;
      case '"':
        *ptr++='\\';
        *ptr++='"';
        mustquote=TRUE;
        break;
      case ' ':
        *ptr++=' ';
        mustquote=TRUE;
        break;
      default:
        v=*value;
        if(v<0x20 || 0x7f<v){
          *ptr++='\\';
          *ptr++='x';
          *ptr++=hex[((v>>4)&15)];
          *ptr++=hex[v&15];
          mustquote=TRUE;
          }
        else{
          *ptr++=v;
          }
        break;
      }
    value++;
    }
  FXASSERT(ptr<&buffer[MAXDELIMITER]);
  *ptr='\0';
  return mustquote;
  }

