/********************************************************************************
*                                                                               *
*                         FTPConfigDlg Class                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: FTPConfigDlg.h,v 1.00 2002/11/20 Exp $                                   *
********************************************************************************/

class FTPSettings;

class FTPConfigDialog : public FXDialogBox
{
	FXDECLARE(FTPConfigDialog)
public:
	FTPConfigDialog(FXWindow* owner, FTPSettings * i_pSettings);
	virtual ~FTPConfigDialog();

	virtual void show();
	virtual FXuint execute(FXuint placement=PLACEMENT_OWNER);

	void setEnabled(FXbool i_fEnabled);
	FXbool getEnabled();

	long onCmdEnabled(FXObject*,FXSelector,void*);
	long onCmdPassive(FXObject*,FXSelector,void*);
	long onCmdServer(FXObject*,FXSelector,void*);
	long onCmdUsername(FXObject*,FXSelector,void*);
	long onCmdPassword(FXObject*,FXSelector,void*);
	long onCmdDirectory(FXObject*,FXSelector,void*);
	long onCmdFirewallType(FXObject*,FXSelector,void*);
	long onCmdFirewallServer(FXObject*,FXSelector,void*);
	long onCmdFirewallUsername(FXObject*,FXSelector,void*);
	long onCmdFirewallPassword(FXObject*,FXSelector,void*);
	long onUpdEnabled(FXObject*,FXSelector,void*);
	long onUpdPassive(FXObject*,FXSelector,void*);
	long onUpdServer(FXObject*,FXSelector,void*);
	long onUpdUsername(FXObject*,FXSelector,void*);
	long onUpdPassword(FXObject*,FXSelector,void*);
	long onUpdDirectory(FXObject*,FXSelector,void*);
	long onUpdFirewallType(FXObject*,FXSelector,void*);
	long onUpdFirewallServer(FXObject*,FXSelector,void*);
	long onUpdFirewallUsername(FXObject*,FXSelector,void*);
	long onUpdFirewallPassword(FXObject*,FXSelector,void*);
	long onCmdOK(FXObject*,FXSelector,void*);
	long onCmdSETICancel(FXObject*,FXSelector,void*);

  enum{
    ID_CHKENABLED=FXMainWindow::ID_LAST,
	ID_CHKPASSIVE,
	ID_TXTFLDSERVER,
	ID_TXTFLDUSERNAME,
	ID_TXTFLDPASSWORD,
	ID_TXTFLDDIRECTORY,
	ID_COMBOFIREWALLTYPE,
	ID_TXTFLDFIREWALLSERVER,
	ID_TXTFLDFIREWALLUSERNAME,
	ID_TXTFLDFIREWALLPASSWORD,
	ID_BTNOK,
	ID_BTNCANCEL
  };

protected:
	void	CopySettings(FTPSettings * o_pTo, const FTPSettings * i_pFrom);

protected:
	FTPSettings * m_pOriginalSettings;
	FTPSettings * m_pCurrentSettings;

	FXCheckButton	*	m_pchkEnabled;
	FXCheckButton	*	m_pchkPassive;
	FXTextField		*	m_ptxtfldServer;
	FXTextField		*	m_ptxtfldUsername;
	FXTextField		*	m_ptxtfldPassword;
	FXTextField		*	m_ptxtfldDirectory;
	FXComboBox		*	m_pcomboFirewallType;
	FXTextField		*	m_ptxtfldFirewallServer;
	FXTextField		*	m_ptxtfldFirewallUsername;
	FXTextField		*	m_ptxtfldFirewallPassword;
	FXButton		*	m_pbtnOK;
	FXButton		*	m_pbtnCancel;

private:
	FTPConfigDialog(){}
};
