/********************************************************************************
*                                                                               *
*                         FTPConfigDlg Class                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* $Id: FTPConfigDlg.cpp,v 1.00 2002/11/20 Exp $                                 *
********************************************************************************/

#include "fx.h"
#include "SETIText.h"
#include "SETIFTPSettings.h"
#include "FTPConfigDlg.h"

//---------------------------------------------------------------------------
// FXTestDialog implementation
FXDEFMAP(FTPConfigDialog) FTPConfigDialogMap[]={
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_CHKENABLED, FTPConfigDialog::onCmdEnabled),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_CHKPASSIVE, FTPConfigDialog::onCmdPassive),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_TXTFLDSERVER, FTPConfigDialog::onCmdServer),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_TXTFLDUSERNAME, FTPConfigDialog::onCmdUsername),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_TXTFLDPASSWORD, FTPConfigDialog::onCmdPassword),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_TXTFLDDIRECTORY, FTPConfigDialog::onCmdDirectory),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_COMBOFIREWALLTYPE, FTPConfigDialog::onCmdFirewallType),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_TXTFLDFIREWALLSERVER, FTPConfigDialog::onCmdFirewallServer),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_TXTFLDFIREWALLUSERNAME, FTPConfigDialog::onCmdFirewallUsername),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_TXTFLDFIREWALLPASSWORD, FTPConfigDialog::onCmdFirewallPassword),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_CHKENABLED, FTPConfigDialog::onUpdEnabled),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_CHKPASSIVE, FTPConfigDialog::onUpdPassive),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_TXTFLDSERVER, FTPConfigDialog::onUpdServer),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_TXTFLDUSERNAME, FTPConfigDialog::onUpdUsername),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_TXTFLDPASSWORD, FTPConfigDialog::onUpdPassword),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_TXTFLDDIRECTORY, FTPConfigDialog::onUpdDirectory),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_COMBOFIREWALLTYPE, FTPConfigDialog::onUpdFirewallType),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_TXTFLDFIREWALLSERVER, FTPConfigDialog::onUpdFirewallServer),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_TXTFLDFIREWALLUSERNAME, FTPConfigDialog::onUpdFirewallUsername),
  FXMAPFUNC(SEL_UPDATE, FTPConfigDialog::ID_TXTFLDFIREWALLPASSWORD, FTPConfigDialog::onUpdFirewallPassword),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_BTNOK, FTPConfigDialog::onCmdOK),
  FXMAPFUNC(SEL_COMMAND, FTPConfigDialog::ID_BTNCANCEL, FTPConfigDialog::onCmdSETICancel),
  };

FXIMPLEMENT(FTPConfigDialog,FXDialogBox,FTPConfigDialogMap,ARRAYNUMBER(FTPConfigDialogMap))

//---------------------------------------------------------------------------
// Construct a dialog box
FTPConfigDialog::FTPConfigDialog(FXWindow* owner, FTPSettings * i_pSettings):
  FXDialogBox(owner,"FTP Settings",DECOR_ALL, 0, 0, 500, 400),
	m_pOriginalSettings(NULL),
	m_pCurrentSettings(i_pSettings),
	m_pchkEnabled(NULL),
	m_pchkPassive(NULL),
	m_ptxtfldServer(NULL),
	m_ptxtfldUsername(NULL),
	m_ptxtfldPassword(NULL),
	m_ptxtfldDirectory(NULL),
	m_pcomboFirewallType(NULL),
	m_ptxtfldFirewallServer(NULL),
	m_ptxtfldFirewallUsername(NULL),
	m_ptxtfldFirewallPassword(NULL)
{
m_pOriginalSettings = new FTPSettings;
CopySettings(m_pOriginalSettings, i_pSettings);

FXVerticalFrame * l_frameMain = new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);

FXGroupBox * l_boxTemp = new FXGroupBox(l_frameMain, "FTP Settings", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
// Make Enabled and Passive checkboxes
FXHorizontalFrame * l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
m_pchkEnabled = new FXCheckButton(l_frameHoriz, "Enabled", this, ID_CHKENABLED);
m_pchkPassive = new FXCheckButton(l_frameHoriz, "Passive Mode", this, ID_CHKPASSIVE);

l_boxTemp = new FXGroupBox(l_frameMain, "Server Settings", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
FXLabel * l_lblTemp = new FXLabel(l_frameHoriz, "Server", NULL, LABEL_NORMAL, 0,0,95,0,20);
m_ptxtfldServer = new FXTextField(l_frameHoriz, 64, this, ID_TXTFLDSERVER);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
l_lblTemp = new FXLabel(l_frameHoriz, "Username", NULL, LABEL_NORMAL, 0,0,95,0,15);
m_ptxtfldUsername = new FXTextField(l_frameHoriz, 64, this, ID_TXTFLDUSERNAME);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
l_lblTemp = new FXLabel(l_frameHoriz, "Password", NULL, LABEL_NORMAL, 0,0,95,0,15);
m_ptxtfldPassword = new FXTextField(l_frameHoriz, 64, this, ID_TXTFLDPASSWORD, TEXTFIELD_NORMAL|TEXTFIELD_PASSWD);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
l_lblTemp = new FXLabel(l_frameHoriz, "Directory", NULL, LABEL_NORMAL, 0,0,95,0,10);
m_ptxtfldDirectory = new FXTextField(l_frameHoriz, 64, this, ID_TXTFLDDIRECTORY);

l_boxTemp = new FXGroupBox(l_frameMain, "Firewall Settings", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
m_pcomboFirewallType = new FXComboBox(l_frameHoriz, 20, 5, this, ID_COMBOFIREWALLTYPE);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
l_lblTemp = new FXLabel(l_frameHoriz, "Firewall Server", NULL, LABEL_NORMAL, 0,0,95,0,0);
m_ptxtfldFirewallServer = new FXTextField(l_frameHoriz, 64, this, ID_TXTFLDFIREWALLSERVER);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
l_lblTemp = new FXLabel(l_frameHoriz, "Firewall Username", NULL, LABEL_NORMAL, 0,0,95,0,0);
m_ptxtfldFirewallUsername = new FXTextField(l_frameHoriz, 64, this, ID_TXTFLDFIREWALLUSERNAME);
l_frameHoriz = new FXHorizontalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
l_lblTemp = new FXLabel(l_frameHoriz, "Firewall Password", NULL, LABEL_NORMAL, 0,0,95,0,0);
m_ptxtfldFirewallPassword = new FXTextField(l_frameHoriz, 64, this, ID_TXTFLDFIREWALLPASSWORD, TEXTFIELD_NORMAL|TEXTFIELD_PASSWD);

// OK and Cancel buttons
l_frameHoriz = new FXHorizontalFrame(l_frameMain, FRAME_LINE|LAYOUT_RIGHT,0,0,0,0, 0,0,0,0);
m_pbtnOK = new FXButton(l_frameHoriz, "OK", NULL, this, ID_BTNOK);
m_pbtnCancel = new FXButton(l_frameHoriz, "Cancel", NULL, this, ID_BTNCANCEL);

// Initial settings
m_pchkEnabled->setCheck(m_pCurrentSettings->m_fEnabled);
m_pchkPassive->setCheck(m_pCurrentSettings->m_fPassive);

m_ptxtfldServer->setText(m_pCurrentSettings->m_strServer);
m_ptxtfldUsername->setText(m_pCurrentSettings->m_strUsername);
m_ptxtfldPassword->setText(m_pCurrentSettings->m_strPassword);
m_ptxtfldDirectory->setText(m_pCurrentSettings->m_strDirectory);

m_pcomboFirewallType->appendItem("None");
m_pcomboFirewallType->appendItem("Site");
m_pcomboFirewallType->appendItem("Proxy");
m_pcomboFirewallType->appendItem("User With Login");
m_pcomboFirewallType->appendItem("User With No Login");
m_pcomboFirewallType->setCurrentItem(m_pCurrentSettings->m_nFirewallIndex);

m_ptxtfldFirewallServer->setText(m_pCurrentSettings->m_strFirewallServer);
m_ptxtfldFirewallUsername->setText(m_pCurrentSettings->m_strFirewallUsername);
m_ptxtfldFirewallPassword->setText(m_pCurrentSettings->m_strFirewallPassword);
}

//---------------------------------------------------------------------------
// Must delete the menus
FTPConfigDialog::~FTPConfigDialog()
{
}

//---------------------------------------------------------------------------
void FTPConfigDialog::setEnabled(FXbool i_fEnabled)
{
m_pCurrentSettings->m_fEnabled = i_fEnabled;
}

//---------------------------------------------------------------------------
FXbool FTPConfigDialog::getEnabled()
{
return m_pCurrentSettings->m_fEnabled;
}

//---------------------------------------------------------------------------
FXuint FTPConfigDialog::execute(FXuint placement)
{
CopySettings(m_pOriginalSettings, m_pCurrentSettings);
return FXDialogBox::execute(placement);
}

//---------------------------------------------------------------------------
void FTPConfigDialog::show()
{
CopySettings(m_pOriginalSettings, m_pCurrentSettings);
FXDialogBox::show();
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdEnabled(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_fEnabled = m_pchkEnabled->getCheck();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdPassive(FXObject*,FXSelector,void*)
{
// Somehow, I need to tell the checkbox in the main window that it should change
// Just tell it to update?
m_pCurrentSettings->m_fPassive = m_pchkPassive->getCheck();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdServer(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_strServer = m_ptxtfldServer->getText();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdUsername(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_strUsername = m_ptxtfldUsername->getText();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdPassword(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_strPassword = m_ptxtfldPassword->getText();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdDirectory(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_strDirectory = m_ptxtfldDirectory->getText();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdFirewallType(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_nFirewallIndex = m_pcomboFirewallType->getCurrentItem();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdFirewallServer(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_strFirewallServer = m_ptxtfldFirewallServer->getText();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdFirewallUsername(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_strFirewallUsername = m_ptxtfldFirewallUsername->getText();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdFirewallPassword(FXObject*,FXSelector,void*)
{
m_pCurrentSettings->m_strFirewallPassword = m_ptxtfldFirewallPassword->getText();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdEnabled(FXObject*,FXSelector,void*)
{
m_pchkEnabled->setCheck(m_pCurrentSettings->m_fEnabled);
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdPassive(FXObject*,FXSelector,void*)
{
m_pchkPassive->setCheck(m_pCurrentSettings->m_fPassive);
m_pCurrentSettings->m_fEnabled ? m_pchkPassive->enable() : m_pchkPassive->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdServer(FXObject*,FXSelector,void*)
{
m_ptxtfldServer->setText(m_pCurrentSettings->m_strServer);
m_pCurrentSettings->m_fEnabled ? m_ptxtfldServer->enable() : m_ptxtfldServer->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdUsername(FXObject*,FXSelector,void*)
{
m_ptxtfldUsername->setText(m_pCurrentSettings->m_strUsername);
m_pCurrentSettings->m_fEnabled ? m_ptxtfldUsername->enable() : m_ptxtfldUsername->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdPassword(FXObject*,FXSelector,void*)
{
m_ptxtfldPassword->setText(m_pCurrentSettings->m_strPassword);
m_pCurrentSettings->m_fEnabled ? m_ptxtfldPassword->enable() : m_ptxtfldPassword->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdDirectory(FXObject*,FXSelector,void*)
{
m_ptxtfldDirectory->setText(m_pCurrentSettings->m_strDirectory);
m_pCurrentSettings->m_fEnabled ? m_ptxtfldDirectory->enable() : m_ptxtfldDirectory->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdFirewallType(FXObject*,FXSelector,void*)
{
m_pcomboFirewallType->setCurrentItem(m_pCurrentSettings->m_nFirewallIndex);
m_pCurrentSettings->m_fEnabled ? m_pcomboFirewallType->enable() : m_pcomboFirewallType->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdFirewallServer(FXObject*,FXSelector,void*)
{
m_ptxtfldFirewallServer->setText(m_pCurrentSettings->m_strFirewallServer);
(m_pCurrentSettings->m_fEnabled && m_pCurrentSettings->m_nFirewallIndex) ?
	m_ptxtfldFirewallServer->enable() : m_ptxtfldFirewallServer->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdFirewallUsername(FXObject*,FXSelector,void*)
{
m_ptxtfldFirewallUsername->setText(m_pCurrentSettings->m_strFirewallUsername);
(m_pCurrentSettings->m_fEnabled && m_pCurrentSettings->m_nFirewallIndex) ?
	m_ptxtfldFirewallUsername->enable() : m_ptxtfldFirewallUsername->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onUpdFirewallPassword(FXObject*,FXSelector,void*)
{
m_ptxtfldFirewallPassword->setText(m_pCurrentSettings->m_strFirewallPassword);
(m_pCurrentSettings->m_fEnabled && m_pCurrentSettings->m_nFirewallIndex) ?
	m_ptxtfldFirewallPassword->enable() : m_ptxtfldFirewallPassword->disable();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdOK(FXObject* o,FXSelector s,void* v)
{
CopySettings(m_pOriginalSettings, m_pCurrentSettings);
// I shouldn't have to call this directly.  Need to figure out how to send message
onCmdAccept(o,s,v);
//handle(this,MKUINT(SEL_COMMAND,ID_ACCEPT),NULL);
//hide();
return 1;
}

//---------------------------------------------------------------------------
long FTPConfigDialog::onCmdSETICancel(FXObject* o,FXSelector s,void* v)
{
CopySettings(m_pCurrentSettings, m_pOriginalSettings);
onCmdCancel(o,s,v);
//handle(this,MKUINT(SEL_COMMAND,ID_CANCEL),NULL);
//hide();
return 1;
}

//---------------------------------------------------------------------------
void FTPConfigDialog::CopySettings(FTPSettings * o_pTo, const FTPSettings * i_pFrom)
{
o_pTo->m_fEnabled              = i_pFrom->m_fEnabled;
o_pTo->m_nFirewallIndex        = i_pFrom->m_nFirewallIndex;
o_pTo->m_strServer             = i_pFrom->m_strServer;
o_pTo->m_strUsername           = i_pFrom->m_strUsername;
o_pTo->m_strPassword           = i_pFrom->m_strPassword;
o_pTo->m_strFirewallServer     = i_pFrom->m_strFirewallServer;
o_pTo->m_strFirewallUsername   = i_pFrom->m_strFirewallUsername;
o_pTo->m_strFirewallPassword   = i_pFrom->m_strFirewallPassword;
o_pTo->m_strDirectory          = i_pFrom->m_strDirectory;
o_pTo->m_fPassive              = i_pFrom->m_fPassive;
}
