/********************************************************************************
*                                                                               *
*                          DebugFlagsList Class                                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: DebugFlagsList.h,v 1.00 2003/04/20 Exp $                                 *
********************************************************************************/

class DebugFlagsList : public FXIconList
{
	FXDECLARE(DebugFlagsList)
public:
	DebugFlagsList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=ICONLIST_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
	virtual ~DebugFlagsList();

	void AddItem(FXString i_strText, FXbool i_fChecked);

public:
  enum{
    ID_ABOUT=FXIconList::ID_LAST,
	ID_FLAGS,
    ID_LAST
  };

public:
	long onCmdFlags(FXObject*,FXSelector,void*);
	long onUpdFlags(FXObject*,FXSelector,void*);

	long onClicked(FXObject*,FXSelector,void*);

protected:
	void LoadGIFIcon(const unsigned char * ik_arrcRawData, FXGIFIcon ** o_ppIcon);

protected:
	static FXGIFIcon *	s_piconChecked;
	static FXGIFIcon *	s_piconUnChecked;

private:
	DebugFlagsList(){}
};
