/********************************************************************************
*                                                                               *
*                            DebugFlags Class                                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: DebugFlags.h,v 1.00 2003/04/19 Exp $                                     *
********************************************************************************/

/*
 Provide an english interface to check the value of debug flags.  These are
 saved in the prefs file and can be enumerated in a listbox.

 Future:

 - Long descriptions
 - Group flags together  Set it up so that entire sections can be
 enabled/disabled together.
 */

//---------------------------------------------------------------------------
#define DBGFLG(flg) DebugFlags::GetInstance()->GetFlag(flg, FALSE)
#define DBGFLGDFLT(flg, dflt) DebugFlags::GetInstance()->GetFlag(flg, dflt)

//---------------------------------------------------------------------------
class FXSettings;

//---------------------------------------------------------------------------
class DebugFlags : public FXDict
{
public:
	DebugFlags(FXSettings * i_pPrefs);
	virtual ~DebugFlags();

	static DebugFlags * GetInstance() { return ms_this; }

public:
	// Write flags to prefs file
	void WriteFlags(FXSettings * i_pPrefs);
	FXbool GetFlag(FXString i_strFlag, FXbool i_fDefault);
	void SetFlag(FXString i_strFlag, FXbool i_fValue);

protected:
  virtual void *createData(const void*);
  virtual void deleteData(void*);

private:
	DebugFlags() {}
	static DebugFlags *	ms_this;
};
