/********************************************************************************
*                                                                               *
*                            DebugFlags Class                                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: DebugFlags.cpp,v 1.00 2003/04/19 Exp $                                   *
********************************************************************************/

#include "fx.h"
#include "FXDict.h"
#include "FXSettings.h"

#include "DebugFlags.h"
//---------------------------------------------------------------------------
DebugFlags * DebugFlags::ms_this = NULL;

const FXchar k_strDebug[] = "DebugFlags";

//---------------------------------------------------------------------------
DebugFlags::DebugFlags(FXSettings * i_pPrefs)
{
FXASSERT(i_pPrefs);
FXASSERT(!ms_this);
ms_this = this;

FXStringDict * l_pSection = i_pPrefs->find(k_strDebug);
if ( l_pSection )
	{
	FXint l_pos = l_pSection->last();
	while ( -1 != l_pos )
		{
		FXString l_str = l_pSection->key(l_pos);
		const void * lk_ptr = l_pSection->data(l_pos);
		FXint l_int = i_pPrefs->readIntEntry(k_strDebug, l_str.text(), 1);
		FXbool l_Flag = (FXbool)l_int;
		insert(l_str.text(), &l_Flag, 1);
		l_pos = l_pSection->prev(l_pos);
		}
	}
}

//---------------------------------------------------------------------------
DebugFlags::~DebugFlags()
{
ms_this = NULL;
}

//---------------------------------------------------------------------------
void DebugFlags::WriteFlags(FXSettings * i_pPrefs)
{
FXint l_pos = last();
while ( -1 != l_pos )
	{
	FXString l_str = key(l_pos);
	void * l_ptr = data(l_pos);
	FXbool l_Flag = *((FXbool *)l_ptr);
	i_pPrefs->writeIntEntry(k_strDebug, l_str.text(), l_Flag);
	l_pos = prev(l_pos);
	}
}

//---------------------------------------------------------------------------
FXbool DebugFlags::GetFlag(FXString i_strFlag, FXbool i_fDefault)
{
FXbool l_fReturn = i_fDefault;
// See if we have a copy in this dict
FXbool * l_pfValue = (FXbool *)find(i_strFlag.text());
if ( !l_pfValue )
	{
	// Now put it in our dict
	l_pfValue = (FXbool *)replace(i_strFlag.text(), &i_fDefault, 1);
	}
if ( l_pfValue )
	{
	l_fReturn = *l_pfValue;
	}
return l_fReturn;
}

//---------------------------------------------------------------------------
void DebugFlags::SetFlag(FXString i_strFlag, FXbool i_fValue)
{
replace(i_strFlag.text(), &i_fValue, 1);
}

//---------------------------------------------------------------------------
void *DebugFlags::createData(const void*ptr)
{
return new FXbool(*((FXbool *)ptr));
}

//---------------------------------------------------------------------------
void DebugFlags::deleteData(void*ptr)
{
FXbool * l_ptr = (FXbool*)ptr;
free(l_ptr);
}

