/********************************************************************************
*                                                                               *
*                             DebugDlg Class                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: DebugDlg.h,v 1.00 2002/09/30 Exp $                                   *
********************************************************************************/

class SETIText;
class DebugFlagsList;

class DebugDialog : public FXDialogBox
{
	FXDECLARE(DebugDialog)
public:
	DebugDialog(FXWindow* owner);
	virtual ~DebugDialog();

	void ShowFlags();

	void SetPrefs(const FXString i_str);
	void SetUserInfo(const FXString i_str);
	void SetWorkUnitInfo(const FXString i_str);
	void SetLog(const FXString i_str);

	void AppendPrefs(const FXString i_str);
	void AppendUserInfo(const FXString i_str);
	void AppendWorkUnitInfo(const FXString i_str);
	void AppendLog(const FXString i_str);

	void ClearPrefs();
	void ClearUserInfo();
	void ClearWorkUnitInfo();

public:
  enum{
    ID_ABOUT=FXDialogBox::ID_LAST,
	ID_FLAGS,
    ID_LAST
  };

public:
	long onCmdFlags(FXObject*,FXSelector,void*);
	long onUpdFlags(FXObject*,FXSelector,void*);

protected:

protected:
	DebugFlagsList*		m_lstFlags;
	SETIText*        	m_txtPrefs;
	SETIText*			m_txtUserInfo;
	SETIText*			m_txtWorkUnitInfo;
	SETIText*			m_txtLog;

	FXGIFIcon *			m_iconOn;
	FXGIFIcon *			m_iconOff;
private:
	DebugDialog(){}
};
