/********************************************************************************
*                                                                               *
*                             DebugDlg Class                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Drake Christensen.   All Rights Reserved.               *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: DebugDlg.cpp,v 1.00 2002/09/30 Exp $                                   *
********************************************************************************/

#include "fx.h"
#include "FXIconList.h"
#include "SETIText.h"
#include "DebugFlagsList.h"
#include "DebugDlg.h"
#include "DebugFlags.h"

//---------------------------------------------------------------------------
// FXTestDialog implementation
FXIMPLEMENT(DebugDialog,FXDialogBox,NULL,0)


//---------------------------------------------------------------------------
// Construct a dialog box
DebugDialog::DebugDialog(FXWindow* owner):
  FXDialogBox(owner,"Debug Output",DECOR_ALL, 0, 0, 500, 850),
		m_lstFlags(NULL),
		m_txtPrefs(NULL),
		m_txtUserInfo(NULL),
		m_txtWorkUnitInfo(NULL),
		m_txtLog(NULL),
		m_iconOn(NULL),
		m_iconOff(NULL)

{
FXVerticalFrame * l_frameMain = new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);

// Debug flags
FXGroupBox * l_boxTemp = new FXGroupBox(l_frameMain, "Debug flags", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
FXVerticalFrame * l_frameTemp = new FXVerticalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
m_lstFlags = new DebugFlagsList(l_frameTemp, this, ID_FLAGS, ICONLIST_DETAILED|ICONLIST_SINGLESELECT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
m_lstFlags->appendHeader("",NULL,500);

// Make m_txtPrefs
l_boxTemp = new FXGroupBox(l_frameMain, "Settings", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
l_frameTemp = new FXVerticalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
m_txtPrefs=new SETIText(l_frameTemp);
m_txtPrefs->setLayoutHints(LAYOUT_FILL_X | LAYOUT_FILL_Y);

// Make m_txtSETIUserInfo
l_boxTemp = new FXGroupBox( l_frameMain, "User info", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
l_frameTemp = new FXVerticalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
m_txtUserInfo=new SETIText(l_frameTemp);
m_txtUserInfo->setLayoutHints(LAYOUT_FILL_X | LAYOUT_FILL_Y);

// Make m_txtSETIWorkUnitInfo
l_boxTemp = new FXGroupBox( l_frameMain, "Work unit info", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
l_frameTemp = new FXVerticalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
m_txtWorkUnitInfo=new SETIText(l_frameTemp);
m_txtWorkUnitInfo->setLayoutHints(LAYOUT_FILL_X | LAYOUT_FILL_Y);

// Make log window
l_boxTemp = new FXGroupBox( l_frameMain, "Log", GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
l_frameTemp = new FXVerticalFrame(l_boxTemp, FRAME_LINE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
m_txtLog=new SETIText(l_frameTemp);
m_txtLog->setLayoutHints(LAYOUT_FILL_X | LAYOUT_FILL_Y);
}

//---------------------------------------------------------------------------
long DebugDialog::onUpdFlags(FXObject*,FXSelector,void*)
{
	return 0;
}

//---------------------------------------------------------------------------
long DebugDialog::onCmdFlags(FXObject*,FXSelector,void*)
{
	return 0;
}

//---------------------------------------------------------------------------
// Must delete the menus
DebugDialog::~DebugDialog()
{
delete m_iconOn;
delete m_iconOff;
}

//---------------------------------------------------------------------------
void DebugDialog::SetPrefs(const FXString i_str)
{
m_txtPrefs->setText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::SetUserInfo(const FXString i_str)
{
m_txtUserInfo->setText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::SetWorkUnitInfo(const FXString i_str)
{
m_txtWorkUnitInfo->setText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::SetLog(const FXString i_str)
{
m_txtLog->setText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::AppendPrefs(const FXString i_str)
{
m_txtPrefs->appendText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::AppendUserInfo(const FXString i_str)
{
m_txtUserInfo->appendText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::AppendWorkUnitInfo(const FXString i_str)
{
m_txtWorkUnitInfo->appendText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::AppendLog(const FXString i_str)
{
m_txtLog->appendText(i_str);
}

//---------------------------------------------------------------------------
void DebugDialog::ClearPrefs()
{
m_txtPrefs->setText("");
}

//---------------------------------------------------------------------------
void DebugDialog::ClearUserInfo()
{
m_txtUserInfo->setText("");
}

//---------------------------------------------------------------------------
void DebugDialog::ClearWorkUnitInfo()
{
m_txtWorkUnitInfo->setText("");
}

//---------------------------------------------------------------------------
void DebugDialog::ShowFlags()
{
// Fill the list
DebugFlags * l_Flags = DebugFlags::GetInstance();
FXint l_pos = l_Flags->last();
while ( -1 != l_pos )
	{
	FXString l_str = l_Flags->key(l_pos);
	const void * lk_ptr = l_Flags->data(l_pos);
	FXbool l_Flag = *((FXbool *)lk_ptr);
	m_lstFlags->AddItem(l_str, l_Flag);
	l_pos = l_Flags->prev(l_pos);
	}
}
